// Copyright 1994 by Jon Dart.  All Rights Reserved.

#ifndef _EMOVE_H
#define _EMOVE_H

#include "board.h"
#include "move.h"

class ExtendedMove : public Move
{
	// "Extended move" class, allows fancier queries about a move,
        // at the cost of some storage.	
	
	public:
	
	enum SpecialType { Normal, KCastle, QCastle, EnPassant, Promotion };
	
	ExtendedMove( const Board &ABoard, const Square start, 
		      const Square dest, 
		      const Piece::PieceType promotion = Piece::Invalid);
	      
	ExtendedMove( const Board &ABoard, const Move &move );
	
	ExtendedMove();
		
	virtual ~ExtendedMove()
	{
	}
	
	const int operator == (const ExtendedMove &m) const;
	// compares moves for equality.
		
	const Piece &Capture() const
	{
		return my_capture;
	}
	
	const Piece &PieceMoved() const
	{
		return my_piecemoved;
	}
	
	const SpecialType Special() const; 
	
	const char *Image() const;
	// returns a human-readable string.  CAUTION: reuses
	// a static buffer for its return value.  This version
	// returns a "better" image than the base class version.
		
        private:
		
	Piece my_piecemoved;
	Piece my_capture;
	byte my_special;
				       
        void set_special(const Board &ABoard);
};

#endif

